/*
   
Easy IK Assignment MacroScript File

Revision History:

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products


This script increases workflow on assigning IK Solvers.
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
-- 
*/


MacroScript HD_IK
	ButtonText:~HD_SOLVER_BUTTONTEXT~
	Category:~INVERSE_KINEMATICS_CATEGORY~ 
	internalCategory:"Inverse Kinematics" 
	Tooltip:~HISTORY_DEPENDENT_IK_SOLVER_TOOLTIP~ 
	Icon:#("MainToolbar",49)
	SilentErrors:(Debug == undefined or Debug != True)

(
	
			
	on isEnabled return selection.count == 1 or 
						selection.count > 1 and
						(
							local h = selection[1].parent 
							h != undefined and h.isSelected and isGroupHead h
						)
	 
	on execute do 
	(
		Global EC_OBJ, EC_TargetObj
		
		Animate Off
		(
			EC_OBJ = selection[1]
			
			-------------------------------------------------------------------------------------------
			-- Define Filter Function for PickObject Selection
			-------------------------------------------------------------------------------------------
			
			fn ChildFilt o = Filters.Is_Child EC_OBJ o or Filters.Is_Parent EC_OBJ o
			
			-------------------------------------------------------------------------------------------
						
			EC_TargetOBJ = PickObject count:1 select:false filter:ChildFilt count:#Multiple Message:~PICK_JOINT_TO_COMPLETE_IK_CHAIN_CAPTION~ Rubberband:EC_OBJ.pos ForceListenerFocus:False
			
			If EC_TargetOBJ != #escape and EC_TargetOBJ != undefined then 
			(
				if Filters.Is_Child EC_OBJ EC_TargetOBJ then
				(
					NIK = HDiksys.ikchain EC_OBJ EC_TargetOBJ True
									
				)
				Else
				(
					NIK = HDiksys.ikchain  EC_TargetOBJ EC_OBJ True
				)
		
				
			)
				
			Max Motion Mode
		)
		
	)		

)
MacroScript HI_IK
	ButtonText:~HI_SOLVER_BUTTONTEXT~
	Category:~HI_IK_INVERSE_KINEMATICS_CATEGORY~ 
	internalCategory:"Inverse Kinematics" 
	Tooltip:~HISTORY_INDEPENDENT_IK_SOLVER_TOOLTIP~ 
	Icon:#("MainToolbar",49)
	SilentErrors:(Debug == undefined or Debug != True)

(
	
	
	-- Check to see if something is selected
		
	on isEnabled return selection.count == 1 or 
						selection.count > 1 and
						(
							local h = selection[1].parent 
							h != undefined and h.isSelected and isGroupHead h
						)
	 
	on execute do 
	(
		Global EC_OBJ, EC_TargetObj
					
		Animate off
		(	
			EC_OBJ = selection[1]
			
			-------------------------------------------------------------------------------------------
			-- Define Filter Function for PickObject Selection
			-------------------------------------------------------------------------------------------
			
			fn ChildFilt o = Filters.Is_Child EC_OBJ o or Filters.Is_Parent EC_OBJ o
			
			-------------------------------------------------------------------------------------------
						
			EC_TargetOBJ = PickObject count:1 select:false filter:ChildFilt count:#Multiple Message:~PICKOBJECT_JOINT_TO_COMPLETE_IK_CHAIN_CAPTION~ Rubberband:EC_OBJ.pos ForceListenerFocus:False
			
			If EC_TargetOBJ != #escape and EC_TargetOBJ != undefined then 
			(
				if Filters.Is_Child EC_OBJ EC_TargetOBJ then
				(
					NIK = iksys.ikchain EC_OBJ EC_TargetOBJ "IKHISolver"
				)
				Else
				(
					NIK = iksys.ikchain  EC_TargetOBJ EC_OBJ "IKHISolver"
				)
							
			)
			Max Motion Mode
		)
					
	)		

)

MacroScript IK_Limb
	ButtonText:~IK_LIMB_SOLVER_BUTTONTEXT~
	Category:~IK_LIMB_INVERSE_KINEMATICS_CATEGORY~ 
	internalCategory:"Inverse Kinematics" 
	Tooltip:~IK_LIMB_SOLVER_TOOLTIP~ 
	Icon:#("MainToolbar",49)
	SilentErrors:(Debug == undefined or Debug != True)

(
	
		
	-- Check to see if something is selected
		
	on isEnabled return selection.count == 1 or 
						selection.count > 1 and
						(
							local h = selection[1].parent 
							h != undefined and h.isSelected and isGroupHead h
						)
	 
	on execute do 
	(
		Global EC_OBJ, EC_TargetObj		
		EC_OBJ = selection[1]
		
		-------------------------------------------------------------------------------------------
		-- Define Filter Function for PickObject Selection
		-------------------------------------------------------------------------------------------
		
		fn ChildFilt o = Filters.Is_Child EC_OBJ o or Filters.Is_Parent EC_OBJ o
		
		-------------------------------------------------------------------------------------------
			
		Animate off
		(
			EC_TargetOBJ = PickObject count:1 select:false filter:ChildFilt Message:~IK_LIMB_JOINT_TO_COMPLETE_IK_CHAIN_CAPTION~ count:#Multiple Rubberband:EC_OBJ.pos ForceListenerFocus:False
			
			If EC_TargetOBJ != #escape and EC_TargetOBJ != undefined then 
			(
				if Filters.Is_Child EC_OBJ EC_TargetOBJ then
				(
					NIK = iksys.ikchain EC_OBJ EC_TargetOBJ "IKLimb"
				)
					Else
				(
					NIK = iksys.ikchain EC_TargetOBJ EC_OBJ  "IKLimb"
				)
						
			)
			
			Max Motion Mode
		)
			
	)	
)



MacroScript SPLINE_IK
	ButtonText:~SPLINEIK_SOLVER_BUTTONTEXT~
	Category:~SPLINE_IK_INVERSE_KINEMATICS_CATEGORY~ 
	internalCategory:"Inverse Kinematics" 
	Tooltip:~SPLINE_IK_SOLVER_TOOLTIP~ 
	Icon:#("MainToolbar",49)
	SilentErrors:(Debug == undefined or Debug != True)

(
	Global EC_OBJ, EC_TargetObj, EC_SplineOBJ, EC_HelperOBJ
	
	-- Check to see if something is selected
	on isEnabled return selection.count == 1 or 
						selection.count > 1 and
						(
							local h = selection[1].parent 
							h != undefined and h.isSelected and isGroupHead h
						)
	 
	on execute do 
	(
		Try
		(
			-------------------------------------------------------------------------------------------
			-- Switch to Motion Panel
			-------------------------------------------------------------------------------------------
		
			IF getCommandPanelTaskMode() != #motion then SetCommandPanelTaskMode Mode:#Motion
			-------------------------------------------------------------------------------------------
			-- Check for Groups and act accordingly
			-------------------------------------------------------------------------------------------
			
			EC_OBJ = selection[1]
			if selection.count > 1 do 
			(
				local h = EC_OBJ.parent 
				if (h != undefined and h.isSelected and isGroupHead h) do EC_OBJ = h
			)
		
					
		Animate off
		(	
			-------------------------------------------------------------------------------------------
			-- Define Filter Functions for PickObject Selection
			-------------------------------------------------------------------------------------------			
			fn ChildFilt o = Filters.Is_Child EC_OBJ o or Filters.Is_Parent EC_OBJ o
			fn ShapeFilt o = superClassOf o == Shape and o != EC_OBJ
			-------------------------------------------------------------------------------------------
						
			EC_TargetOBJ = PickObject count:1 select:false filter:ChildFilt count:#Multiple Message:~SPLINE_IK_JOINT_TO_COMPLETE_IK_CHAIN_CAPTION~ Rubberband:EC_OBJ.pos ForceListenerFocus:False			
			If EC_TargetOBJ != #escape and EC_TargetOBJ != undefined then 
			(
				if Filters.Is_Child EC_OBJ EC_TargetOBJ then
				(
					NIK = iksys.IKChain  EC_OBJ EC_TargetOBJ "SplineIKSolver"
				)
				Else
				(
					NIK = iksys.IKChain  EC_TargetOBJ EC_OBJ "SplineIKSolver"
				)
							
			)
			
			EC_SplineOBJ = PickObject count:1 select:false filter:ShapeFilt count:#Multiple Message:~SPLINE_IK_PICK_SPLINE_TO_ASSIGN_SPLINEIK_CAPTION~ Rubberband:EC_TargetOBJ.pos ForceListenerFo
			
			If EC_SplineOBJ != undefined and EC_SplineOBJ != ~EC_SPLINEOBJ_NOT_NONE~ then
			(
				-------------------------------------------------------------------------------------------
				-- Make the Spline the goal shape of the SplineIK
				-------------------------------------------------------------------------------------------
				NIK.transform.controller.pickShape = EC_SplineOBJ		
								
				-------------------------------------------------------------------------------------------			
				-- Add SplinIKControl Modifier and Create Helpers
				-------------------------------------------------------------------------------------------		
				mod = Spline_IK_Control()
				AddModifier EC_SplineOBJ (mod)
				mod.createHelper(0)
				EC_HelperOBJ = mod.helper_list[1]
				
				-- Set the upnode to the first helper
				NIK.controller.upnode = EC_HelperObj

				-------------------------------------------------------------------------------------------
				-- Add List Controller and Path Constraint
				-------------------------------------------------------------------------------------------
				local cont
				if Filters.Is_Child EC_OBJ EC_TargetOBJ then
				(
					cont = AddListController EC_OBJ ~EC_OBJ_POS_CONTROLLER_NAME~ Position_List
					If classof cont[listCtrl.GetActive cont].object != Path_Constraint then constraint = AddConstraint EC_OBJ ~CONSTRAINT_EC_OBJ_POS~ Path_Constraint true
					else constraint = cont[listCtrl.GetActive cont].object
				)
				else
				(
					cont = AddListController EC_TargetOBJ ~EC_TARGETOBJ_NAME~ Position_List
					If classof cont[listCtrl.GetActive cont].object != Path_Constraint then constraint = AddConstraint EC_TargetOBJ ~EC_TARGETOBJ_PART_NAME~ Path_Constraint true
					else constraint = cont[listCtrl.GetActive cont].object
				)

				-------------------------------------------------------------------------------------------
				-- Add Path Constraint Object Target as the spline
				-------------------------------------------------------------------------------------------		
				constraint.AppendTarget EC_SplineObj 50
				DeleteKeys constraint.percent.controller
				constraint.percent = 0.0
							
				-------------------------------------------------------------------------------------------
				-- Set Active Controller
				-------------------------------------------------------------------------------------------
						
				SetActiveController cont constraint
				
				--Format "%\n"  (EC_OBJ.name + ~IS_POSITION_CONSTRAINED_TO~ + EC_HelperOBJ.name) to:Listener
							
				Select EC_OBJ
			)	

			Max Motion Mode
		)
		
		)
		Catch (MessageBox ~SPLINEOK_NOT_COMPLETED_CAPTION~ Title:~IK_TITLE~)
					
	)		

)






-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCnkiYmniZkO6Lugo9UA8oD9OJtED5a8rBy
-- YBjEwVFS5yBadhWJb+BIJwGomEZL/PcagkSeM8BASlSSAc34+JZenDdP8Jd35l/5
-- Qtb2Py/8HRtmXy6LQSkIRTqJRNpLhmVdUao7NEiAGYZU0uot/OuEGbIX4LB3XfIB
-- XPvgtb3fwDbIN9ym+Tps822rsKHOkG39EIbHDWADuRAuEkkAMDJBBGjjljw6pSBw
-- nOeTrjwjF9xhk/VhmtP8v++mMRXH4z86gXv7saPcYcCx7sZXVq/XTIPsoRO8ucDG
-- G8P79FMs795RxZJafNe9YPpa9Dy+qXtVG6VTNC16dUEz+8jH6O3K
-- -----END-SIGNATURE-----